** Script to compile the gallup ethical standards & honesty data
cd "data"
set more off
clear *

label define trust 1 "Very High" 2 "High" 3 "Average" 4 "Low" 5 "Very Low"
label define states 58 "AL" 85 "AK" 72 "AZ" 61 "AR" 81 "CA" 73 "CO" 16 "CT" 25 "DE" 27 "DC" 55 "FL" 54 "GA" 84 "HI" 74 "ID" 34 "IL" 33 "IN" 43 "IA" 48 "KS" 56 "KY" 62 "LA" 11 "ME" 24 "MD" 14 "MA" 32 "MI" 42 "MN" 59 "MS" 44 "MO" 71 "MT" 47 "NE" 77 "NV" 12 "NH" 22 "NJ" 78 "NM" 21 "NY" 52 "NC" 45 "ND" 31 "OH" 63 "OK" 82 "OR" 23 "PA" 15 "RI" 53 "SC" 46 "SD" 57 "TN" 64 "TX" 76 "UT" 13 "VT" 51 "VA" 83 "WA" 26 "WV" 41 "WI" 75 "WY"
label define education 1 "None or grade 1 - 4" 2 "Grade 5 6 or 7" 3 "Grade 8" 4 "High school incomplete (Grades 9 - 11)" 5 "High school graduate Grade 12" 6 "Technical trade or business after high school" 7 "College/university incomplete" 8 "College/university graduate or more"
label define genders 0 "Male" 1 "Female"
label define racelabels 1 "White" 2 "Black" 3 "Hispanic" 4 "Asian" 5 "American Indian" 6 "Pacific Islander" 7 "Other Race"

infix 1 lines weight 1:1-1 sex 1:52-52 state 1:58-59 doctors 1:21 advertisers 1:22 lawyers 1:23 congressmen 1:24 busexecs 1:25 journalists 1:26 senators 1:27 unionleaders 1:28 collegeteachers 1:29 engineers 1:32 buildingcontractors 1:33 educ 1:47 age 1:48-49 race 1:52-52 using 953.DAT, clear
gen date=mdy(6,11,1976)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels

save gallup1976-06, replace



infix 1 lines weight 1:1-1 sex 1:97-97 state 1:106-107 doctors 1:75 advertisers 1:76 lawyers 1:77 congressmen 1:78 busexecs 1:79 journalists 1:80 senators 1:81 unionleaders 1:82 collegeteachers 1:83 engineers 1:84 buildingcontractors 1:85 realtors 1:86 clergy 1:87 carsalesmen 1:88 insurancesales 1:89 educ 1:94 age 1:95-96 race 1:97-97 using 980.dat, clear
gen date=mdy(7,22,1977)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels

save gallup1977-07, replace



infix 1 lines weight 1:1-1 sex 1:128-128 state 1:135-136 doctors 1:38 realtors 1:40 policemen 1:39 bankers 1:41 statepoliticians 1:42 localpoliticians 1:43 educ 1:123 age 1:124-125 race 1:126-126 using 982.dat, clear
gen date=mdy(8,19,1977)
label values educ education
label values state states
foreach var of varlist doctors realtors policemen bankers statepoliticians localpoliticians {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels

save gallup1977-08, replace



infix 1 lines weight 1:1-1 sex 1:136-136 state 1:144-145 doctors 1:8 advertisers 1:9 lawyers 1:10 congressmen 1:11 busexecs 1:12 journalists 1:13 senators 1:14 unionleaders 1:15 collegeteachers 1:16 engineers 1:17 buildingcontractors 1:18 realtors 1:19 clergy 1:20 carsalesmen 1:21 insurancesales 1:22 funeraldirectors 1:23 policemen 1:24 bankers 1:25 statepoliticians 1:26 localpoliticians 1:27 pharmacists 1:28 stockbrokers 1:29 dentists 1:30 tvreporters 1:31 newspaperreporters 1:32 educ 1:129 age 1:130-131 race 1:134-134 using 1178.dat, clear
gen date=mdy(7,27,1981)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels

save gallup1981-07, replace



infix 1 lines weight 1:1-1 sex 1:126-126 state 1:138-139 doctors 1:29 advertisers 1:30 lawyers 1:31 congressmen 1:32 busexecs 1:33 journalists 1:34 senators 1:35 unionleaders 1:36 collegeteachers 1:37 engineers 1:38 buildingcontractors 1:39 realtors 1:40 clergy 1:41 carsalesmen 1:42 insurancesales 1:43 funeraldirectors 1:44 policemen 1:45 bankers 1:46 statepoliticians 1:47 localpoliticians 1:48 pharmacists 1:49 stockbrokers 1:50 dentists 1:51 tvreporters 1:52 newspaperreporters 1:53 educ 1:121 age 1:122-123 race 1:125-125 using 1215.dat, clear
gen date=mdy(5,20,1983)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels

save gallup1983-05, replace



infix 1 lines weight 1:5-7 sex 1:144-144 state 1:155-156 doctors 1:62 advertisers 1:63 lawyers 1:64 congressmen 1:65 busexecs 1:66 journalists 1:67 senators 1:68 unionleaders 1:69 collegeteachers 1:70 engineers 1:71 buildingcontractors 1:72 realtors 1:73 clergy 1:74 carsalesmen 1:75 insurancesales 1:76 funeraldirectors 1:77 policemen 1:78 bankers 1:79 statepoliticians 1:80 localpoliticians 1:81 pharmacists 1:82 stockbrokers 1:83 dentists 1:84 tvreporters 1:85 newspaperreporters 1:86 educ 1:137 age 1:138-139 race 1:143-143 using 1255.dat, clear
gen date=mdy(7,12,1985)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (2=1) (3 4=2) (5 6=7)
replace race=.d if race==0
label values race racelabels
replace weight = weight/100
save gallup1985-07, replace



infix 1 lines weight 1:7-9 sex 1:35-35 state 1:39-40 doctors 1:79 advertisers 1:99 lawyers 1:90 congressmen 1:92 busexecs 1:91 journalists 1:85 senators 1:89 unionleaders 1:94 collegeteachers 1:78 engineers 1:81 buildingcontractors 1:88 realtors 1:95 clergy 1:77 carsalesmen 1:100 insurancesales 1:98 funeraldirectors 1:84 policemen 1:82 bankers 1:83 statepoliticians 1:97 localpoliticians 1:93 pharmacists 1:76 stockbrokers 1:96 dentists 1:80 tvreporters 1:86 newspaperreporters 1:87 educ 1:25 age 1:23-24 race 1:33-33 using g933003w1.dat, clear
gen date=mdy(2,8,1990)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=.d if race==4
replace race=.d if race==0
replace race=.r if race==5
label values race racelabels
replace weight = weight/100
save gallup1990-02, replace



infix 1 lines weight 1:7-9 sex 1:15-15 state 1:33-34 doctors 1:142 advertisers 1:162 lawyers 1:153 congressmen 1:155 busexecs 1:154 journalists 1:148 senators 1:152 unionleaders 1:157 collegeteachers 1:141 engineers 1:144 buildingcontractors 1:151 realtors 1:158 clergy 1:140 carsalesmen 1:163 insurancesales 1:161 funeraldirectors 1:147 policemen 1:145 bankers 1:146 statepoliticians 1:160 localpoliticians 1:156 pharmacists 1:139 stockbrokers 1:159 dentists 1:143 tvreporters 1:149 newspaperreporters 1:150 educ 1:18 age 1:16-17 race 1:19-19 using g122034.dat, clear
gen date=mdy(5,16,1991)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=.d if race==4
replace race=.d if race==0
replace race=.r if race==5
label values race racelabels
replace weight = weight/100
save gallup1991-05, replace



infix 1 lines weight 1:7-9 sex 1:17-17 state 1:28-29 doctors 1:50 advertisers 1:70 lawyers 1:61 congressmen 1:63 busexecs 1:62 journalists 1:56 senators 1:60 unionleaders 1:65 collegeteachers 1:49 engineers 1:52 buildingcontractors 1:59 realtors 1:66 clergy 1:48 carsalesmen 1:71 insurancesales 1:69 funeraldirectors 1:55 policemen 1:53 bankers 1:54 statepoliticians 1:68 localpoliticians 1:64 pharmacists 1:47 stockbrokers 1:67 dentists 1:51 tvreporters 1:57 newspaperreporters 1:58 educ 1:20 age 1:18-19 race 1:21-21 using g322002.dat, clear
gen date=mdy(6,26,1992)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=4) (4=7)
replace race=.d if race==5
replace race=.r if race==6
label values race racelabels
replace weight = weight/100
save gallup1992-06, replace



infix 5 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 5:40 advertisers 5:60 lawyers 5:51 congressmen 5:53 busexecs 5:52 journalists 5:46 senators 5:50 unionleaders 5:55 collegeteachers 5:39 engineers 5:42 buildingcontractors 5:49 realtors 5:56 clergy 5:38 carsalesmen 5:61 insurancesales 5:59 funeraldirectors 5:45 policemen 5:43 bankers 5:44 statepoliticians 5:58 localpoliticians 5:54 pharmacists 5:37 stockbrokers 5:57 dentists 5:41 tvreporters 5:47 newspaperreporters 5:48 educ 1:47 age 1:45-46 race 1:48-48 using A422003.DAT, clear
gen date=mdy(7,19,1993)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=4) (4=7)
replace race=.d if race==5
replace race=.r if race==6
label values race racelabels
replace weight = weight/100
save gallup1993-07, replace



infix 6 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 5:41 advertisers 5:61 lawyers 5:52 congressmen 5:54 busexecs 5:53 journalists 5:47 senators 5:51 unionleaders 5:56 collegeteachers 5:40 engineers 5:43 buildingcontractors 5:50 realtors 5:57 clergy 5:39 carsalesmen 5:62 insurancesales 5:60 funeraldirectors 5:46 policemen 5:44 bankers 5:45 statepoliticians 5:59 localpoliticians 5:55 pharmacists 5:38 stockbrokers 5:58 dentists 5:42 tvreporters 5:48 newspaperreporters 5:49 educ 1:47 age 1:45-46 race 6:76-77 using A0807024.DAT, clear
gen date=mdy(9,23,1994)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1994-09, replace



infix 6 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 5:48 advertisers 5:68 lawyers 5:59 congressmen 5:61 busexecs 5:60 journalists 5:54 senators 5:58 unionleaders 5:63 collegeteachers 5:47 engineers 5:50 buildingcontractors 5:57 realtors 5:64 clergy 5:46 carsalesmen 5:69 insurancesales 5:67 funeraldirectors 5:53 policemen 5:51 bankers 5:52 statepoliticians 5:66 localpoliticians 5:62 pharmacists 5:45 stockbrokers 5:65 dentists 5:49 tvreporters 5:55 newspaperreporters 5:56 educ 1:47 age 1:45-46 race 1:48-48 using 9510017.DAT, clear
gen date=mdy(10,19,1995)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
recode race (3=7)
replace race=.d if race==4
replace race=.r if race==5
label values race racelabels
replace weight = weight/100
save gallup1995-10, replace



infix 6 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 6:27 advertisers 6:47 lawyers 6:38 congressmen 6:40 busexecs 6:39 journalists 6:33 senators 6:37 unionleaders 6:42 collegeteachers 6:26 engineers 6:29 buildingcontractors 6:36 realtors 6:43 clergy 6:25 carsalesmen 6:48 insurancesales 6:46 funeraldirectors 6:32 policemen 6:30 bankers 6:31 statepoliticians 6:45 localpoliticians 6:41 pharmacists 6:24 stockbrokers 6:44 dentists 6:28 tvreporters 6:34 newspaperreporters 6:35 educ 1:47 age 1:45-46 race 5:14-15 using A9612037.DAT, clear
gen date=mdy(12,9,1996)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1996-12, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 6:26 advertisers 6:46 lawyers 6:37 congressmen 6:39 busexecs 6:38 journalists 6:32 senators 6:36 unionleaders 6:41 collegeteachers 6:25 engineers 6:28 buildingcontractors 6:35 realtors 6:42 clergy 6:24 carsalesmen 6:47 insurancesales 6:45 funeraldirectors 6:31 policemen 6:29 bankers 6:30 statepoliticians 6:44 localpoliticians 6:40 pharmacists 6:23 stockbrokers 6:43 dentists 6:27 tvreporters 6:33 newspaperreporters 6:34 educ 1:47 age 1:45-46 race 5:14-15 using g9711028.DAT, clear
gen date=mdy(11,6,1997)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1997-11, replace



infix 7 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors 6:39 advertisers 6:59 lawyers 6:50 congressmen 6:52 busexecs 6:51 journalists 6:45 senators 6:49 unionleaders 6:54 collegeteachers 6:38 engineers 6:41 buildingcontractors 6:48 realtors 6:55 clergy 6:37 carsalesmen 6:60 insurancesales 6:58 funeraldirectors 6:44 policemen 6:42 bankers 6:43 statepoliticians 6:57 localpoliticians 6:53 pharmacists 6:36 stockbrokers 6:56 dentists 6:40 tvreporters 6:46 newspaperreporters 6:47 educ 1:47 age 1:45-46 race 5:14-15 using A9810040.DAT, clear
gen date=mdy(10,23,1998)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1998-10, replace

* Note that 1999 had a split sample
infix 8 lines weight 1:13-15 sex 1:44-44 state 1:78-79 doctors_a 6:34 busexecs_a 6:46 carsalesmen_a 6:55 pharmacists_a 6:31 doctors_b 7:13 busexecs_b 7:14 carsalesmen_b 7:15 pharmacists_b 7:12 advertisers 6:54 lawyers 6:45 congressmen 6:47 journalists 6:40 senators 6:44 unionleaders 6:49 collegeteachers 6:33 engineers 6:36 buildingcontractors 6:43 realtors 6:50 clergy 6:32  insurancesales 6:53 funeraldirectors 6:39 policemen 6:37 bankers 6:38 statepoliticians 6:52 localpoliticians 6:48  stockbrokers 6:51 dentists 6:35 tvreporters 6:41 newspaperreporters 6:42 educ 1:47 age 1:45-46 race 5:14-15 using A9911044.dat, clear
replace doctors_a=doctors_b if doctors_a==.
replace busexecs_a=busexecs_b if busexecs_a==.
replace carsalesmen_a=carsalesmen_b if carsalesmen_a==.
replace pharmacists_a=pharmacists_b if pharmacists_a==.
rename doctors_a doctors
rename busexecs_a busexecs
rename carsalesmen_a carsalesmen
rename pharmacists_a pharmacists
drop doctors_b busexecs_b carsalesmen_b pharmacists_b
gen date=mdy(11,4,1999)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters {
    label values `var' trust
    replace `var'=.d if `var'==6
    replace `var'=.r if `var'==0
    replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3)
label values race racelabels
replace weight = weight/100
save gallup1999-11, replace



infix 1 lines weight 1:7-10 sex 1:56-56 state 1:13-14 doctors 1:99 advertisers 1:119 lawyers 1:110 congressmen 1:112 busexecs 1:111 journalists 1:105 senators 1:109 unionleaders 1:114 collegeteachers 1:98 engineers 1:101 buildingcontractors 1:108 realtors 1:115 clergy 1:97 carsalesmen 1:120 insurancesales 1:118 funeraldirectors 1:104 policemen 1:102 bankers 1:103 statepoliticians 1:117 localpoliticians 1:113 pharmacists 1:96 stockbrokers 1:116 dentists 1:100 tvreporters 1:106 newspaperreporters 1:107 nurses 1:125 educ 1:59 age 1:57-58 race 1:62-63 using G2000-49.DAT, clear
gen date=mdy(11,13,2000)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers buildingcontractors realtors clergy carsalesmen insurancesales funeraldirectors policemen bankers statepoliticians localpoliticians pharmacists stockbrokers dentists tvreporters newspaperreporters nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2000-11, replace



infix 1 lines weight 1:7-10 sex 1:58-58 state 1:13-14 doctors 1:101 advertisers 1:114 lawyers 1:108 congressmen 1:110 busexecs 1:109 journalists 1:106 senators 1:107 unionleaders 1:111 collegeteachers 1:100 engineers 1:103 clergy 1:99 carsalesmen 1:115 insurancesales 1:113 policemen 1:104 bankers 1:105 pharmacists 1:98 stockbrokers 1:112 dentists 1:102 nurses 1:117 educ 1:61 age 1:59-60 race 1:64-65 using 200144.dat, clear
gen date=mdy(11,26,2001)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders collegeteachers engineers clergy carsalesmen insurancesales policemen bankers pharmacists stockbrokers dentists nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2001-11, replace



infix 1 lines weight 1:7-10 sex 1:65-65 state 1:13-14 advertisers 1:88 busexecs 1:86 collegeteachers 1:85 policemen 1:87 nurses 1:89 educ 1:68 age 1:66-67 race 1:71-72 using 20020207.dat, clear
gen date=mdy(2,8,2002)
label values educ education
label values state states
foreach var of varlist advertisers busexecs collegeteachers policemen nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2002-02, replace



infix 1 lines weight 1:7-10 sex 1:66-66 state 1:13-14 doctors 1:111 advertisers 1:103 lawyers 1:110 congressmen 1:108 busexecs 1:105 journalists 1:118 unionleaders 1:119 buildingcontractors 1:115 realtors 1:120 clergy 1:107 carsalesmen 1:106 funeraldirectors 1:116 policemen 1:113 bankers 1:104 pharmacists 1:109 stockbrokers 1:121 nurses 1:112 educ 1:69 age 1:67-68 race 1:72-73 using 2002_11_22x.dat, clear
gen date=mdy(11,22,2002)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists unionleaders buildingcontractors realtors clergy carsalesmen funeraldirectors policemen bankers pharmacists stockbrokers nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2002-11, replace



infix 1 lines weight 1:7-10 sex 1:73-73 state 1:13-14 doctors 1:119 advertisers 1:111 lawyers 1:118 congressmen 1:116 busexecs 1:113 journalists 1:128 senators 1:130 collegeteachers 1:123 engineers 1:125 clergy 1:115 carsalesmen 1:114 insurancesales 1:127 policemen 1:121 bankers 1:112 pharmacists 1:117 stockbrokers 1:133 dentists 1:124 nurses 1:120 educ 1:76 age 1:74-75 race 1:79-80 using ga200351.dat, clear
gen date=mdy(11,16,2003)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators collegeteachers engineers clergy carsalesmen insurancesales policemen bankers pharmacists stockbrokers dentists nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2003-11, replace



infix 1 lines weight 1:7-10 sex 1:75-75 state 1:13-14 doctors 1:121 advertisers 1:113 lawyers 1:120 congressmen 1:118 busexecs 1:115 clergy 1:117 carsalesmen 1:116 policemen 1:123 bankers 1:114 statepoliticians 1:132 localpoliticians 1:128 pharmacists 1:119 tvreporters 1:133 newspaperreporters 1:130 nurses 1:122 educ 1:78 age 1:76-77 race 1:81-82 using g200444.dat, clear
gen date=mdy(11,21,2004)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs clergy carsalesmen policemen bankers statepoliticians localpoliticians pharmacists tvreporters newspaperreporters nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2004-11, replace



infix 1 lines weight 1:7-10 sex 1:118-118 state 1:13-14 doctors 1:169 advertisers 1:161 lawyers 1:168 congressmen 1:166 busexecs 1:163 journalists 1:176 senators 1:181 unionleaders 1:177 buildingcontractors 1:173 realtors 1:178 clergy 1:165 carsalesmen 1:164 funeraldirectors 1:174 policemen 1:171 bankers 1:162 pharmacists 1:167 stockbrokers 1:179 nurses 1:170 educ 1:121 age 1:119-120 race 1:124-125 using g200556.dat, clear
gen date=mdy(11,17,2005)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators unionleaders buildingcontractors realtors clergy carsalesmen funeraldirectors policemen bankers pharmacists stockbrokers nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==10
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2005-11, replace



infix 1 lines weight 1:5-8 sex 1:71-71 state 1:11-12 doctors 1:118 advertisers 1:110 lawyers 1:117 congressmen 1:115 busexecs 1:112 journalists 1:127 senators 1:129 collegeteachers 1:122 engineers 1:124 clergy 1:114 carsalesmen 1:113 insurancesales 1:126 policemen 1:120 bankers 1:111 pharmacists 1:116 stockbrokers 1:132 dentists 1:123 nurses 1:119 educ 1:74 age 1:72-73 race 1:77-78 using G200651.dat, clear
gen date=mdy(12,8,2006)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators collegeteachers engineers clergy carsalesmen insurancesales policemen bankers pharmacists stockbrokers dentists nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4) (10=5)
label values race racelabels

save gallup2006-12, replace



infix 1 lines weight 1:7-10 sex 1:81-81 state 1:13-14 doctors 1:135 advertisers 1:127 lawyers 1:134 busexecs 1:129 congressmen 1:132 clergy 1:131 carsalesmen 1:130 policemen 1:137 bankers 1:128 statepoliticians 1:146 localpoliticians 1:142 pharmacists 1:133 tvreporters 1:147 newspaperreporters 1:144 nurses 1:136 educ 1:84 age 1:82-83 race 1:87-88 using g200739.dat, clear
gen date=mdy(11,30,2007)
label values educ education
label values state states
foreach var of varlist doctors advertisers congressmen lawyers busexecs clergy carsalesmen policemen bankers statepoliticians localpoliticians pharmacists tvreporters newspaperreporters nurses {
    label values `var' trust
    replace `var'=.d if `var'==6
    replace `var'=.r if `var'==0
    replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
replace race=.d if race==2
replace race=.r if race==3
replace race=.r if race==4
replace race=.r if race==5
recode race (1=7) (6=1) (7=2) (8=3) (9=4)
label values race racelabels

save gallup2007-11, replace



infix 1 lines weight 1:7-10 sex 1:67-67 state 1:11-12 doctors 1:129 advertisers 1:121 lawyers 1:128 congressmen 1:126 busexecs 1:123 journalists 1:136 unionleaders 1:137 buildingcontractors 1:133 realtors 1:138 clergy 1:125 carsalesmen 1:124 funeraldirectors 1:134 policemen 1:131 bankers 1:122 pharmacists 1:127 stockbrokers 1:139 nurses 1:130 educ 1:70 age 1:68-69 white 1:73 black 1:74 other1 1:75-76 other2 1:77-78 using usa200844.dat, clear
gen date=mdy(11,7,2008)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists unionleaders buildingcontractors realtors clergy carsalesmen funeraldirectors policemen bankers pharmacists stockbrokers nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
gen race=1 if white==1
replace race=2 if black==1 & race==.
replace race=3 if race==. & (other1==20 | other2==20)
replace race=4 if race==. & (other1==6 | other2==6)
replace race=5 if race==. & (other1==7 | other2==7)
replace race=6 if race==. & (other1==8 | other2==8)
replace race=7 if race==. & (other1==1 | other2==1)
drop white black other1 other2
label values race racelabels

save gallup2008-11, replace



infix 1 lines weight 1:7-10 sex 1:67-67 state 1:11-12 doctors 1:136 advertisers 1:128 lawyers 1:135 congressmen 1:133 busexecs 1:130 journalists 1:145 senators 1:147 collegeteachers 1:140 engineers 1:142 clergy 1:132 carsalesmen 1:131 insurancesales 1:144 policemen 1:138 bankers 1:129 pharmacists 1:134 stockbrokers 1:149 dentists 1:141 nurses 1:137 educ 1:70 age 1:68-69 white 1:73 black 1:74 other1 1:75-76 other2 1:77-78 using usa200921.dat, clear
gen date=mdy(11,20,2009)
label values educ education
label values state states
foreach var of varlist doctors advertisers lawyers congressmen busexecs journalists senators collegeteachers engineers clergy carsalesmen insurancesales policemen bankers pharmacists stockbrokers dentists nurses {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
replace age=. if age==0
recode sex (1 3 5 7 9 = 0) (0 2 4 6 8 = 1)
replace educ=. if educ==9
replace educ=.d if educ==0
label values sex genders
gen race=1 if white==1
replace race=2 if black==1 & race==.
replace race=3 if race==. & (other1==20 | other2==20)
replace race=4 if race==. & (other1==6 | other2==6)
replace race=5 if race==. & (other1==7 | other2==7)
replace race=6 if race==. & (other1==8 | other2==8)
replace race=7 if race==. & (other1==1 | other2==1)
drop white black other1 other2
label values race racelabels

save gallup2009-11, replace

use "2010_11_19x.dta", clear /*Data came directly from Gallup; not yet up on Roper*/
gen date=mdy(11,19,2010)
label values educ education
label values state states
rename wtfctr weight
foreach var of varlist q3* {
	label values `var' trust
	replace `var'=.d if `var'==6
	replace `var'=.r if `var'==0
	replace `var'=.r if `var'==7
}
for X in any q3a q3b q3c q3d q3e q3f q3g q3h q3i q3j q3k q3l q3m q3n q3o q3p q3q q3r q3s q3t q3u q3v \ ///
	Y in any advertisers bankers busexecs carsalesmen clergy congressmen pharmacists lawyers doctors nurses policemen mechanics daycareproviders schoolteachers judges localpoliticians militaryofficers newspaperreporters nursinghomeoperators statepoliticians tvreporters lobbyists : ///
	rename X Y
drop mechanics daycareproviders schoolteachers judges militaryofficers nursinghomeoperators lobbyists
replace age=. if age==0
gen sex=gr-1
label values sex genders
replace educ=. if educ==9
replace educ=.d if educ==0
gen race=1 if racewh==1
replace race=2 if racebk==1 & race==.
replace race=3 if race==. & (raceoth_1==20 | raceoth_2==20)
replace race=4 if race==. & (raceoth_1==6 |  raceoth_2==6)
replace race=5 if race==. & (raceoth_1==7 |  raceoth_2==7)
replace race=6 if race==. & (raceoth_1==8 |  raceoth_2==8)
replace race=7 if race==. & (raceoth_1==1 |  raceoth_2==1)
label values race racelabels

keep date weight sex state advertisers-tvreporters age sex race educ

save gallup2010-11, replace


clear *
local files: dir . files "gallup*.dta"
set obs 1
gen str20 survey="X"
foreach f of local files {
	di "`f'"
	append using "`f'"
	replace survey="`f'" if survey==""
}
drop if survey=="X"

cd ..
save gallup_honesty_raw.dta, replace
